(function () {
    let app = angular.module('recruitment', []);

    app.directive('recruitment', function () {
        return {
            restrict: 'E',
            templateUrl: 'templates/employees/recruitment.html',
            controller: function ($scope, $rootScope) {
                var ctrl = this;
                $scope.GetLocalized = Helpers.GetLocalized;
                ctrl.currentTier = $rootScope.tierInfo.currentTier;
                $scope.EmployeeTypeNames = EmployeeTypeNames;
                ctrl.view = '';

                Helpers.MovePropToIsolatedScope($rootScope, $scope, 'settings.activeRecruitment');

                ctrl.employeeTypes = EmployeeTypes
                    .map(x => {
                        return {
                            name: x.name,
                            title: `<i class="${x.name} fa ${Helpers.GetEmployeeTypeCssClass(x.name)}"></i> `
                            + (ctrl.currentTier >= x.tier
                                ? `${Helpers.GetLocalized(x.name)}`
                                : `<span class="color-secondary-grey">${Helpers.GetLocalized(x.name)}</span>`),
                            unlocked: ctrl.currentTier >= x.tier,
                            tier: x.tier,
                            description: Helpers.GetLocalized(x.description)
                        }
                    });

                ctrl.recruitment = {
                    employeeType: ctrl.employeeTypes[0],
                    level: 'Beginner',
                    price: 0,
                    totalMinutes: 1440,
                    completedMinutes: 0
                };

                $scope.$watch('recruitmentCtrl.recruitment', recruitment => {
                    recruitment.price = 2200;

                    switch (recruitment.level) {
                        case "Intermediate":
                            recruitment.price = 5000;
                            break;
                        case "Expert":
                            recruitment.price = 12000;
                            break;
                    }

                    recruitment.price *= (recruitment.totalMinutes / 60) / 30;
                }, true);

                Helpers.RootScopeWatchAndDestroy($scope, 'settings.activeRecruitment.completedMinutes', val => {
                    if (val == null) return;
                    ctrl.hoursLeft = Math.ceil(($rootScope.settings.activeRecruitment.totalMinutes - $rootScope.settings.activeRecruitment.completedMinutes) / 60);
                    ctrl.recruitmentPercentage = Math.floor($rootScope.settings.activeRecruitment.completedMinutes * 100 / $rootScope.settings.activeRecruitment.totalMinutes);
                });

                ctrl.tiersForEmployeeLevels = Helpers.GetTierForEmployeeLevels();

                ctrl.startRecruiting = () => {
                    $rootScope.safeBuy(() => {
                        $rootScope.settings.activeRecruitment = ctrl.recruitment;
                        $rootScope.settings.activeRecruitment.employeeTypeName = ctrl.recruitment.employeeType.name;
                    }, ctrl.recruitment.price, Helpers.GetLocalized('transaction_recruitment'))
                };

                ctrl.cancel = () => {
                    $rootScope.settings.activeRecruitment = null;
                    ctrl.recruitment.completedMinutes = 0;
                }
            },
            controllerAs: 'recruitmentCtrl'
        };
    });

    app.directive('candidates', function () {
        return {
            restrict: 'E',
            templateUrl: 'templates/employees/candidates.html',
            controller: function ($scope, $rootScope) {
                var ctrl = this;
                $scope.GetLocalized = Helpers.GetLocalized;
                ctrl.wer = Helpers.CalculateWer();

                // Clear all notifications
                $rootScope.settings.candidates.forEach(candidate => $rootScope.removeNotification(candidate.id));

                ctrl.remove = employee => {
                    _.remove($rootScope.settings.candidates, x => x.id == employee.id);
                };

                ctrl.hire = employee => {
                    employee.hired = $rootScope.settings.date;
                    _.remove($rootScope.settings.candidates, x => x.id == employee.id);
                    $rootScope.settings.unassignedEmployees.push(employee);
                    $rootScope.$broadcast(GameEvents.EmployeeChange);
                    PlaySound(Sounds.stamp);
                };
            },
            controllerAs: 'candidatesCtrl'
        };
    });


})();

